#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion

namespace gov.va.med.vbecs.BOL.UnitTests
{
	[TestFixture]
	public class BOL_CautionTag : BaseTest 
	{
		private BOL.CautionTag _cautionTag;
		private BOL.BloodUnit _bloodUnit;
		private BOL.Patient _patient;
		private BOL.VbecsUser _user;
		
		private DataTable _dtOrderedUnits;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();


			if (this.RefreshData)
			{
				Guid unitGuid = DataCreator.CreateRBCBloodUnit(false).BloodUnitGuid;
				Guid patientGuid = Guid.NewGuid();

				DataCreator.CreatePatientAssignment(unitGuid, patientGuid, true, true);

				this._dtOrderedUnits = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM OrderedUnit WHERE BloodUnitGuid = '" + unitGuid.ToString() + "'", true);

				this._user = this.TestUser;
				_user.LogonToDivision( this.TestDivisionCode );

				this._bloodUnit = new BloodUnit( (Guid) this._dtOrderedUnits.Rows[0][TABLES.BloodUnit.BloodUnitGuid]);
				this._patient = new Patient(patientGuid);

				this.RefreshData = false;
			}

			this._cautionTag = new BOL.CautionTag(_bloodUnit, _patient, _user, false);
		}


		[Test]
		public void Ctor_Pass()
		{			
			//Default
			BOL.CautionTag ct = new BOL.CautionTag(this._bloodUnit, this._patient, this._user, false);
			Assert.IsNotNull(ct, "ct");

			//			//Code coverage - ABo/Rh Mismatch
			Guid unitGuid1 = Guid.NewGuid();
			Guid patientGuid1 = Guid.NewGuid();
			Guid bpGuid1 = DataCreator.GetRandomBloodProduct(false, Common.ComponentClass.RBC).BloodProductGuid;

			DataCreator.CreateBloodUnit(unitGuid1, Guid.NewGuid(), Guid.Empty, bpGuid1, false);
			DataCreator.CreatePatientAssignment(unitGuid1, patientGuid1, false,false );

			BOL.BloodUnit bu1 = new BOL.BloodUnit(unitGuid1);
			BOL.Patient patient1 = new BOL.Patient(patientGuid1);
			BOL.CautionTag ct1 = new BOL.CautionTag(bu1, patient1, this._user, false);
			Assert.IsNotNull(ct1, "1");


			//Code coverage - printed tags
			Guid unitGuid4 = Guid.NewGuid();
			Guid patientGuid4 = Guid.NewGuid();
			Guid bpGuid4 = DataCreator.GetRandomBloodProduct(false, Common.ComponentClass.RBC, "E002").BloodProductGuid;

			DataCreator.CreateBloodUnit(unitGuid4, Guid.NewGuid(), Guid.Empty, bpGuid4, false);
			DataCreator.CreatePatientAssignment(unitGuid4, patientGuid4, true, false);

			BOL.BloodUnit bu4 = new BOL.BloodUnit(unitGuid4);
			BOL.Patient patient4 = new BOL.Patient(patientGuid4);
			Common.LogonUser.PrintedTags.Add(unitGuid4, patientGuid4);

			BOL.CautionTag ct4 = new BOL.CautionTag(bu4, patient4, this._user, false);
			Assert.IsNotNull(ct4, "4-PrintedTags");
			Common.LogonUser.PrintedTags.Clear();
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void Ctor_Fail()
		{			
			BOL.CautionTag ct = new BOL.CautionTag(null, null, null, false);
		}

		[Test]
		public void BloodUnit_Pass()
		{		
			Assert.AreEqual(_bloodUnit, this._cautionTag.BloodUnit, "BloodUnit");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void BloodUnit_Fail()
		{			
		}

		[Test]
		public void Patient_Pass()
		{			
			Assert.AreEqual(this._patient, this._cautionTag.Patient, "Patient");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void Patient_Fail()
		{			
		}

		[Test]
		public void OverrideComment_Pass()
		{
			Random random = new Random();
			// set comment to non empty string so broken rule remains unbroken
			string comment = random.Next(0, 1000).ToString();

			int brokenRulesBefore = _cautionTag.BrokenRulesCount;
			_cautionTag.OverrideComment = comment;
			
			Assert.AreEqual(comment, _cautionTag.OverrideComment,  "Value");
			Assert.AreEqual(brokenRulesBefore, _cautionTag.BrokenRulesCount, "BrokenRulesCount");
		}
		[Test]
		public void OverrideComment_Fail()
		{
			_cautionTag.SetInitialBrokenRules("FrmPrintCautionTagByPatient");
			int brokenRulesBefore = _cautionTag.BrokenRulesCount;
			// set to empty string to trigger broken rule
			_cautionTag.OverrideComment = string.Empty;
			
			Assert.AreEqual(brokenRulesBefore +1, _cautionTag.BrokenRulesCount  , "BrokenRulesCount");
		}


		[Test]
		public void VerifyPatientHasUnits_Pass()
		{
			Assert.AreEqual(true,  BOL.CautionTag.VerifyPatientHasUnits(_patient.PatientGuid) );
		}
		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void VerifyPatientHasUnits_Fail()
		{
			BOL.CautionTag.VerifyPatientHasUnits(Guid.Empty);
		}
		
		[Test]
		public void GetUnitsForDisplay_Pass()
		{
			Assert.AreEqual(true, BOL.CautionTag.GetUnitsForDisplay().Rows.Count > 0,  "Rows.Count" );
		}
		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void GetUnitsForDisplay_Fail()
		{
		}

		[Test]
		public void GetUnitsForDisplay_Patient_Pass()
		{
			Assert.AreEqual(true, BOL.CautionTag.GetUnitsForDisplay(_patient.PatientGuid).Count > 0,  "Count" );
		}
		[Test]
		public void GetUnitsForDisplay_Patient_Fail()
		{
			Assert.AreEqual(0, BOL.CautionTag.GetUnitsForDisplay(Guid.NewGuid()).Count,  "Count" );
		}

		[Test]
		public void GetPatients_Pass()
		{
			Assert.AreEqual(true, BOL.CautionTag.GetPatients(_bloodUnit.BloodUnitGuid).Count > 0,  "Count" );
		}
		[Test]
		public void GetPatients_Fail()
		{
			Assert.AreEqual(0, BOL.CautionTag.GetPatients(Guid.NewGuid()).Count,  "Count");
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void PrintBlankCautionTags_Pass()
		{
			// Untestable: print must be verified manually
		}
		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void PrintBlankCautionTags_Fail()
		{
			// Untestable: print must be verified manually
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void PrintBlankBtrfs_Pass()
		{
			// Untestable: print must be verified manually
		}
		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void PrintBlankBtrfs_Fail()
		{
			// Untestable: print must be verified manually
		}

		[Test]
		[Ignore( StandardIgnoreReasons.Untestable )]
		public void Print_Pass()
		{
			// Untestable: print must be verified manually
		}
		[Test]
		[Ignore( StandardIgnoreReasons.Untestable )]
		public void Print_Fail()
		{
			// Untestable: print must be verified manually
		}

		[Test]
		public void GetEmptyBtrfDataSet_Pass()
		{			
			DataSet dsBtrf = BOL.CautionTag.GetEmptyBtrfDataSet();

			Assert.IsNotNull(dsBtrf, "DataSet must not be NULL");
			Assert.AreEqual(1, dsBtrf.Tables.Count, "Tables.Count");
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void GetEmptyBtrfDataSet_Fail()
		{
		}


		[Test]
		public void GetBtrfDataSet_Pass()
		{
			DataSet ds = _cautionTag.GetBtrfDataSet();

			Assert.IsNotNull(ds, "DataSet must not be NULL");
			Assert.AreEqual(1, ds.Tables.Count, "Tables.Count");
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void GetBtrfDataSet_Fail()
		{
		}

		
		[Test]
		public void IsEmergencyIssue_Pass()
		{
			bool tstValue = this._cautionTag.IsEmergencyIssue();

			Assert.IsNotNull(tstValue);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void IsEmergencyIssue_Fail()
		{
		}


		[Test]
		public void Beep_Pass()
		{
			bool retValue = this._cautionTag.Beep;

			Assert.AreEqual(retValue, _cautionTag.Beep);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ReadOnlyProperty )]
		public void Beep_Fail()
		{

		}

		[Test]
		public void Message_Pass()
		{
			string messageSQL = " SELECT ou.BloodUnitGuid, pt.PatientGuid  " +
						 " FROM OrderedUnit ou " + 
						 " JOIN OrderedComponent oc ON oc.OrderedComponentGuid = ou.OrderedComponentGuid " +
						 " JOIN PatientOrder po ON oc.PatientOrderGuid = po.PatientOrderGuid " + 
						 " JOIN PatientTreatment pt ON po.PatientTreatmentGuid = pt.PatientTreatmentGuid " + 
						 " WHERE ou.DivisionCode = '" + this.TestDivisionCode + "' AND ou.RecordStatusCode = 'A' AND ou.CrossmatchRequiredIndicator = 1 AND CrossmatchResultCode = 'I'";
            
			DataTable dtGuids = UnitTestUtil.RunSQLGetDataTable(messageSQL,false);
			if(dtGuids.Rows.Count == 0)
			{
				Guid tmpGuid = DataCreator.CreateRBCBloodUnit(false).BloodUnitGuid;
				DataCreator.CreatePatientAssignment(tmpGuid, Guid.NewGuid(), false, true);

				dtGuids = UnitTestUtil.RunSQLGetDataTable(messageSQL, true);
			}
			Guid patientGuid = (Guid)dtGuids.Rows[0][TABLES.Patient.PatientGuid];
			Guid unitGuid = (Guid)dtGuids.Rows[0][TABLES.BloodUnit.BloodUnitGuid];

			BOL.BloodUnit bloodUnit = new BOL.BloodUnit(unitGuid);
			BOL.Patient patient = new BOL.Patient(patientGuid);

			BOL.CautionTag cautionTag = new CautionTag(bloodUnit, patient, _user, false);

			Assert.AreEqual(true, cautionTag.Message.Trim().Length>0, "Length > 0");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void Message_Fail()
		{
		}


		[Test]
		public void PrintOK_Pass()
		{
			bool retValue = this._cautionTag.PrintOK;

			Assert.AreEqual(retValue, _cautionTag.PrintOK);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void PrintOK_Fail()
		{
		}


		[Test]
		public void OverrideRequired_Pass()
		{
			bool tstValue = _cautionTag.OverrideRequired;

			Assert.AreEqual(_cautionTag.OverrideRequired, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void OverrideRequired_Fail()
		{
		}


		[Test]
		public void EmergencyIssue_Pass()
		{
			bool tstValue = this._cautionTag.EmergencyIssue;

			Assert.AreEqual(tstValue, this._cautionTag.EmergencyIssue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void EmergencyIssue_Fail()
		{

		}

		[Test]
		public void ExceptionReportEntries_Pass()
		{
			ArrayList tstValue = this._cautionTag.ExceptionReportEntries;

			Assert.AreEqual(tstValue, this._cautionTag.ExceptionReportEntries);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void ExceptionReportEntries_Fail()
		{
		}


		[Test]
		public void ExceptionReportGenerated_Pass()
		{
			this._cautionTag.ExceptionReportGenerated = true;
			Assert.AreEqual(true, this._cautionTag.ExceptionReportGenerated, "True-");

			this._cautionTag.ExceptionReportGenerated = false;
			Assert.AreEqual(false, this._cautionTag.ExceptionReportGenerated, "False-");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ExceptionReportGenerated_Fail()
		{
		}

		[Test]
		public void GenerateExceptionReport_Pass()
		{
			this._cautionTag.ExceptionReportGenerated = true;
			bool retValue = this._cautionTag.GenerateExceptionReport();

			Assert.AreEqual(true, retValue, "Return Value");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GenerateExceptionReport_Fail()
		{
		}


		[Test]
		[ExpectedException(typeof(BOL.BusinessObjectException))]
		public void LoadDataRowFromThis_Pass()
		{
			this._cautionTag.LoadDataRowFromThis(this._dtOrderedUnits.NewRow());
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThis_Fail()
		{
		}

		[Test]
		public void GetBtrfDataSet_TRsFromConversion_Pass()
		{
			Guid patientGuid = this._patient.PatientGuid;
			Guid TRGuidFromConv = Guid.NewGuid();
			
			string insertTransfusionReqFromConv = "INSERT INTO PATIENTTRANSFUSIONREQUIREMENT (";
			insertTransfusionReqFromConv += TABLES.PatientTransfusionRequirement.PatientTransfusionRequirementGuid + ",";
			insertTransfusionReqFromConv += TABLES.PatientTransfusionRequirement.PatientGuid + ",";
			insertTransfusionReqFromConv += TABLES.PatientTransfusionRequirement.TransfusionRequirementText + ",";
			insertTransfusionReqFromConv += TABLES.PatientTransfusionRequirement.TransfusionRequirementCategoryCode + ",";
			insertTransfusionReqFromConv += TABLES.PatientTransfusionRequirement.CreateDate + ",";
			insertTransfusionReqFromConv += TABLES.PatientTransfusionRequirement.CreateUser + ",";
			insertTransfusionReqFromConv += TABLES.PatientTransfusionRequirement.CreateDivisionCode + ",";
			insertTransfusionReqFromConv += TABLES.PatientTransfusionRequirement.VistaConversionIndicator + ",";
			insertTransfusionReqFromConv += TABLES.PatientTransfusionRequirement.AntibodyTypeId + ",";
			insertTransfusionReqFromConv += TABLES.PatientTransfusionRequirement.RecordStatusCode + ",";
			insertTransfusionReqFromConv += TABLES.PatientTransfusionRequirement.LastUpdateDate + ",";
			insertTransfusionReqFromConv += TABLES.PatientTransfusionRequirement.LastUpdateUser + ",";
			insertTransfusionReqFromConv += TABLES.PatientTransfusionRequirement.LastUpdateFunctionId + ")";
			insertTransfusionReqFromConv += "VALUES (";
			insertTransfusionReqFromConv += "'" + TRGuidFromConv.ToString() + "',";
			insertTransfusionReqFromConv += "'" + patientGuid.ToString() + "',";
			insertTransfusionReqFromConv += "'Anti-C',";
			insertTransfusionReqFromConv += "'AS',";
			insertTransfusionReqFromConv += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertTransfusionReqFromConv += "'" + Environment.UserName + "',";
			insertTransfusionReqFromConv += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertTransfusionReqFromConv += "'1',";
			insertTransfusionReqFromConv += "'5',";
			insertTransfusionReqFromConv += "'C',";  //TR from conversion
			insertTransfusionReqFromConv += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertTransfusionReqFromConv += "'" + Environment.UserName + "',";
			insertTransfusionReqFromConv += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			UnitTestUtil.RunSQL(insertTransfusionReqFromConv);
			
			Guid TRGuidFromVbecs = Guid.NewGuid();
			string insertTransfusionReqFromVbecs = "INSERT INTO PATIENTTRANSFUSIONREQUIREMENT (";
			insertTransfusionReqFromVbecs += TABLES.PatientTransfusionRequirement.PatientTransfusionRequirementGuid + ",";
			insertTransfusionReqFromVbecs += TABLES.PatientTransfusionRequirement.PatientGuid + ",";
			insertTransfusionReqFromVbecs += TABLES.PatientTransfusionRequirement.TransfusionRequirementText + ",";
			insertTransfusionReqFromVbecs += TABLES.PatientTransfusionRequirement.TransfusionRequirementCategoryCode + ",";
			insertTransfusionReqFromVbecs += TABLES.PatientTransfusionRequirement.CreateDate + ",";
			insertTransfusionReqFromVbecs += TABLES.PatientTransfusionRequirement.CreateUser + ",";
			insertTransfusionReqFromVbecs += TABLES.PatientTransfusionRequirement.CreateDivisionCode + ",";
			insertTransfusionReqFromVbecs += TABLES.PatientTransfusionRequirement.VistaConversionIndicator + ",";
			insertTransfusionReqFromVbecs += TABLES.PatientTransfusionRequirement.AntibodyTypeId + ",";
			insertTransfusionReqFromVbecs += TABLES.PatientTransfusionRequirement.RecordStatusCode + ",";
			insertTransfusionReqFromVbecs += TABLES.PatientTransfusionRequirement.LastUpdateDate + ",";
			insertTransfusionReqFromVbecs += TABLES.PatientTransfusionRequirement.LastUpdateUser + ",";
			insertTransfusionReqFromVbecs += TABLES.PatientTransfusionRequirement.LastUpdateFunctionId + ")";
			insertTransfusionReqFromVbecs += "VALUES (";
			insertTransfusionReqFromVbecs += "'" + TRGuidFromVbecs.ToString() + "',";
			insertTransfusionReqFromVbecs += "'" + patientGuid.ToString() + "',";
			insertTransfusionReqFromVbecs += "'Anti-E',";
			insertTransfusionReqFromVbecs += "'AS',";
			insertTransfusionReqFromVbecs += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertTransfusionReqFromVbecs += "'" + Environment.UserName + "',";
			insertTransfusionReqFromVbecs += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertTransfusionReqFromVbecs += "'0',";
			insertTransfusionReqFromVbecs += "'16',";
			insertTransfusionReqFromVbecs += "'A',";  //TR from VBECS
			insertTransfusionReqFromVbecs += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertTransfusionReqFromVbecs += "'" + Environment.UserName + "',";
			insertTransfusionReqFromVbecs += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			UnitTestUtil.RunSQL(insertTransfusionReqFromVbecs);

			DataSet dsCautionTagData = this._cautionTag.GetBtrfDataSet();
			//
			Assert.IsTrue(dsCautionTagData.Tables[0].Rows[0][ARTIFICIAL.PatientTRANString].ToString().IndexOf("C") != -1);
			Assert.IsTrue(dsCautionTagData.Tables[0].Rows[0][ARTIFICIAL.PatientTRANString].ToString().IndexOf("E") != -1);
		
			string deleteTRs = "DELETE FROM PATIENTTRANSFUSIONREQUIREMENT WHERE PatientTransfusionRequirementGuid = '" + TRGuidFromConv.ToString() + "'";
			UnitTestUtil.RunSQL(deleteTRs);

			deleteTRs = "DELETE FROM PATIENTTRANSFUSIONREQUIREMENT WHERE PatientTransfusionRequirementGuid = '" + TRGuidFromVbecs.ToString() + "'";
			UnitTestUtil.RunSQL(deleteTRs);
		}
	}
}

#endif
